// @input Asset.InternetModule serviceModule
// @input Component.Text output

const req = RemoteServiceHttpRequest.create();
req.url = "https://catfact.ninja/fact";
req.method = RemoteServiceHttpRequest.HttpRequestMethod.Get;

script.serviceModule.performHttpRequest(req, (res) => {
    if (res.statusCode === 200) {
        script.output.text = JSON.parse(res.body).fact;
    } else if (res.statusCode === 400 && res.headers["x-camera-kit-error-type"]) {
        script.output.text = `Error: ${res.body}`;
    } else {
        script.output.text = `Error: Unexpected HTTP status code ${res.statusCode}.`;
    }
});
